<?php
namespace Api\Controller;


use Addin\Logic\BoardLogic;
use Addin\Model\BoardModel;
use Addin\Model\ExtAttachModel;
use Api\Model\BoardRecvModel;
use Api\Model\BoardVisiterModel;
use Common\Lib\SaasSDK;
use Common\Lib\Jump;
use Common\Model\DispersedModel;
use Think\Controller;

class DispersedAddinController extends Controller{
	
	public function _initialize(){
		
		header('Access-Control-Allow-Origin:*');
		SaasSDK::autoFirstSaas();
		
	}
	
	
	public function board_add(){
		
		$data['board_id'] = I("board_id");
		$data['board_name'] = I("board_name");
		$data['board_intro'] = I("board_intro");
		$data['board_content'] = I("board_content");
		$data['board_create_id'] = I("board_create_id");
		$data['board_create_name'] = I("board_create_name");
		$data['board_create_date'] = I("board_create_date");
		$data['board_from_dept'] = I("board_from_dept");
		$data['board_is_public'] = I("board_is_public");
		$data['board_status'] = I("board_status");
		$data['board_send_type'] = I("board_send_type");
		$data['board_type'] = I("board_type");
		
		BoardModel::DD()->add($data);
		
		Jump::success("添加成功");
		
	}
	
	public function board_repeal(){
		$boardId = I("board_id");
		if(empty($boardId)){
			Jump::errror("3001"," not found the  board_id");
		}
		
		$where['board_id'] = $boardId;
		BoardModel::DD()->where($where)->save(['board_status' => '0']);
		Jump::success("撤回成功");
		
	}
	
	public function board_del(){
		
		$boardId = I("board_id");
		if(empty($boardId)){
			Jump::errror("3001"," not found the  board_id");
		}
		
		$where['board_id'] = $boardId;
		BoardModel::DD()->where($where)->delete();
		
		Jump::success("删除成功");
		
	}
	
	
	
	public function set_read(){
		
		$postData['board_id']=I('board_id');
		$postData['user_id']=I("user_id");
		$postData['user_name']=I('user_name');
		$postData['gid']=I('gid');
		$postData['read_date']=I('read_date');
		$res = BoardVisiterModel::DD()->add($postData);
		if($res===false){
			Jump::errror(BoardVisiterModel::DD()->getError());
		}
		
		Jump::success("删除成功");
		
	}
	
	
	
	public function upload_file(){
		
		$file_info = I("file_info");
		if(empty($file_info)){
			Jump::errror("3301","file_info is  empty");
		}
		
		$file_info_arr=json_decode($file_info,true);
		if(empty($file_info_arr)){
			LogWrite("file_info: ".$file_info);
			Jump::errror("3301","file_info json_decode error");
			
		}
		
		if($file_info_arr){
			foreach( $file_info_arr as $item ){
                // 不能是 .php, 不能带 ..
                if (preg_match('/\.(php|phtml|php3|php7)$/i', $item['file_path'])) {
                    Jump::errror(301,"禁止上传非法文件后缀");
                }

                if (strpos($item['file_path'], '../')) {
                    Jump::errror(301,"禁止相对路径");
                }

				$res = move_uploaded_file($_FILES['file']['tmp_name'], SITE_PATH.'/'.str_replace('[webserver]','',$item['file_path']));
				if($res===false){
					LogWrite("文件移动失败 ".$item['file_path']);
				}
			}
		}
		$res = ExtAttachModel::DD()->addAll($file_info_arr);
		if($res===false){
			$message = "err : ".ExtAttachModel::DD()->getError();
			LogWrite($message);
			Jump::errror("3001",$message);
		}
		
		Jump::success("添加成功");
	}
	
	public function board_add_user(){
		$board_id = I("board_id");
		if(empty($board_id)){
			Jump::errror("3301","board_id is  empty");
		}
		$rece_user = I("rece_user");
		if(empty($rece_user)){
			Jump::errror("3301","rece_user is  empty");
		}
		$rece_user_arr=json_decode($rece_user,true);
		if(empty($rece_user_arr)){
			Jump::errror("3301","file_info json_decode error");
			
		}
		$res = BoardRecvModel::DD()->addAll($rece_user_arr);
		if($res===false){
			$message = "err : ".BoardRecvModel::DD()->getError();
			Jump::errror("3001",$message);
		}
		
		//  发送通知
		$board = BoardModel::DD()->where(['board_id'=>$board_id])->find();
		
		$localServerId = DispersedModel::DD()->getLocalServerId();
		if(empty($localServerId)){
			Jump::errror("3001","localServerId   为空");
		}
		
		//过滤本域的通知
		$receNewArr = array_filter($rece_user_arr, static function($item) use ($localServerId){
			if(strpos($item['emp_id'], $localServerId) === 0){
				return true;
			}
		});
		
		$recvs = array_values($receNewArr);
		if(empty($recvs)){
			Jump::errror("3001","recvs   为空");
		}
		
		BoardLogic::DD()->sned_board_notfy($board, $recvs);
		
		
		Jump::success("公告人员添加成功");
		
	}
	
}