<?php

/**
 * 处理未登录的公共部分
 * @author jc
 *
 */
namespace Home\Controller;
use Common\Lib\MarkPassErr;
use Common\Lib\SaasSDK;
use Common\Model\UserModel;
use Think\Controller;
use \Common\Lib\Cas;

class LoginController extends Controller {
	
	// 允许访问的应用
	 private  static  $refer=[
	 	'kjb'
	 ];
 
	/**
	 * 自动登录
	 * @curl  http://127.0.0.1:8000/home/login/auto_login?account=admin&password=bigant@2018&refer=kbj
	 */
	public function auto_login(){
		
		$account = I('account');
		$password = I('password');
		$type = I('type'); //1=原始密码,2=md5密码
		//$refer = I('refer');
		//if(empty($refer) || !in_array($refer, self::$refer, true)){
		//	$this->error("缺少必要的参数");
		//}
		
		if(!$account){
			$this->error(" 账号为空");
		}
		if(!$password){
			$this->error(" 密码无效");
		}
		if(!in_array($account,['admin','superadmin','security','auditor'])){
			$this->error("非管理员不能登录");
		}
		
		$saas=SaasSDK::firstSaas();
		
		
		try{
			
			if($type==1){
				$res = \Common\Lib\SaasSDK::login($saas['saas_id'],$account,$password);
			}elseif($type==2){
				$res = \Common\Lib\SaasSDK::loginByMd5Pwd($saas['saas_id'],$account,$password);
			}
			
		}catch (\Exception $e){
			$res = sp_api_fail(0, L('_LOGIN_DB_ERROR_'));
			die($res);
		}
		
		
		redirect('/Admin/index/index');
		
	}

	/**
	 * cas sso单点登录
	 * create by sl at 2017/12/18
	 */
	public function loginCas() {
		$saas   = I('saas'); 
		$ticket = I('ticket');

		//判断是否传递saas
		if (! $saas) {
			$saas = cookie('saas');
		}
		if (!$saas) {
			$this->error(L('_LOGIN_SAAS_EMPTY_'),'index');exit;
		}


		$cas = new Cas();
		//未传ticket时跳入登录页，传ticket则验证ticket
		if (empty($ticket)) {
			$cas->casLogin($saas);
		}
		$userLogin = $cas->casGetUser();
		if ($userLogin == false) {
			$this->error(L('_CAS_AUTHENTICATION_FAILED_'),'index');exit;
		}

		//连接saas
		$saasModel = D('Common/Saas');
		$res = $saasModel->validSaas($saas);
		if (! $res['status']){
			$this->error($res['err_msg'],'index');exit;
		}
		$saas = $res['data'];
		sp_set_saas($saas);


		//得到用户
		$userModel = D('Common/User');
		$userMap = ['user_login' => $userLogin];
		$userField = 'user_id,user_name,user_login,user_pwd,user_pwd_type,user_status,user_is_super,user_picture';
		$userInfo = $userModel->field($userField)->where($userMap)->find();
		if (empty($userInfo)) {
			$this->error(L('_NOT_LOGIN_'),'index');exit;
		}

		//判断用户类型，非管理员不能登录
		$userLogic = D('Common/User','Logic');
		$userType = $userLogic->getUserType($userLogin, $userInfo['user_id'], $userInfo['user_is_super']);
		if ($userType == 0){
			$this->error(L('_ONLY_MANAGER_LOGIN_'),'index');
		}

		$userInfo['user_type'] = $userType;
		sp_set_user($userInfo);

		$webServer = sp_get_host();
		header('Location:'.$webServer.'/index.php/Admin/Public/Load');
	}

	/**
	 * 登录
	 */
	public function index(){

		$to = I('to','admin','htmlspecialchars') ;
		$app = I('app');
		$saas = I('saas');

		
		//20170418 针对只有一个SAAS的企业，默认给出企业ID
		//李成提的需求
		$M = D('Common/Saas');
		$data = null ;
		if ($saas){
			//20170518 如果是登妨系统管理台，那个数据库密码如果是 默认密码，那么显示出来
			$data = $M->where(array('saas_name'=>$saas))->fetchSql(false)->select();
		}

		//
		if (! $data){
			$data = $M->fetchSql(false)->order("SAAS_CREATE_DATE asc")->select();
		} 

		
		$saas = $data[0]['saas_name'] ;

		

		//20170419 加入默认的帐号
		$account = htmlspecialchars($_COOKIE['account']) ;
		if (! $account){
			$account = 'superadmin';
		}
		
		
		$this->assign('saas',$saas) ;
		$this->assign('account',$account) ;
		$this->assign('metaTitle',C('PRODUCT_NAME') . ' ' . L('_LOGIN_TITLE_')) ;
		$this->assign('to',$to) ;
		$this->assign('app',$app) ;
		
		if(I('flag')){
			$this->assign('flag',I('flag')) ;
		}
		

		//20170518 如果是登妨系统管理台，那个数据库密码如果是 默认密码，那么显示出来
		if (($to == 'admin') && ($account == 'admin') &&($saas)){
			if (count($data) > 0){
				//获取数据库的密码
				sp_set_saas($data[0]);
				$M = D('Common/User');
				$pwd = $M->where(array('user_login'=>$account))->getField('user_pwd');
				if ($pwd == sp_password(DEFAULT_ADMIN_PWD)){
					$this->assign('default_pwd',DEFAULT_ADMIN_PWD) ;
				}
			}
			
		}
		$this->display();
 
	}
	
	
	/**
	 * 登录验证
	 */
	public function login_post(){

		$saas = I('saas') ;
		$account = I('account') ;
		$password = I('d') ;
		$to = I('to','admin','htmlspecialchars');
		$expire = 30*60; //30分钟失效
		cookie('saas',$saas,$expire);
		cookie('account',$account,$expire);

		if (C('CHECK_VERIFY')){
			if(!$this->check_verify(I('verify'))){
				$this->error(L('_CAPTCHA_ERROR_'));exit;
			};
		}
		
		tag("login_begin");
		
		try{
			$pwd = \Common\Lib\Aes::AesDecodeJsPwd(APP_SECRET, $password);
			$password=md5($pwd);
		}catch(\Exception $e){
			$this->error($e->getMessage());
		}
		
		//当数据库配置错误的时候，会出错
		try{
			$res = \Common\Lib\SaasSDK::login($saas,$account,$password);
			
		}catch (\Exception $e){
			$res = sp_api_fail(0, L('_LOGIN_DB_ERROR_'));
		}
		

		if (! $res['status']){
			tag("login_error");
			$this->error($res['err_msg']);
		}

		$user = $res['data'] ;
		
		if (!D()->autoCheckToken($_POST)){
			// 令牌验证错误
			$this->error("表单token验证失败");
		}

		if (sp_user_type() == 0){
			
			if ($to == 'admin'){
				if ($user['user_type'] == 0){
					$this->error(L('_ONLY_MANAGER_LOGIN_'));
				}
			}
		}

		$url = $this->toUrl($to);

		$app = I('app');
		if (!empty($app) && !in_array($app, ['pan','admin'])) {
			$url = U('addin/'.$app.'/index');
		}
		// dump($url);exit;

		tag("login_end");
		$this->success(L('_LOADING_'),$url);
	
	}
	
	/**
	 * eg can: http://192.168.0.120:8010/home/login/loginByToken?uid=1&token=asdasdasdadasadad
	 * eg can't: http://192.168.0.120:8010/home/login/loginByToken?uid=103&token=asdasdasdadasadad
	 */
	public function loginByToken(){
		//$data = D('Common/Saas')->find('EA8AD463-2FC7-FC68-E193-EEA29ECC6EC8');
		//sp_set_saas($data);
		SaasSDK::autoFirstSaas();
		$uid = I("uid");
		$token = I("token");

        $res= D("Common/AppCenter")->checkToken($uid,$token);
        if($res!==true){
			die(json_encode(sp_api_fail(ERR_OP_ERR, "token 效验失败", ),JSON_UNESCAPED_UNICODE)) ;
		}

		$user  = D("Common/User")->where(['user_id'=>$uid])->find();
		if(!$user) die(json_encode(sp_api_fail(ERR_OP_ERR, L('_USER_NOT_EXIST_')), JSON_UNESCAPED_UNICODE)) ;

		//获取登录权限
		//$userLogic = D('Common/User','Logic');
		//$userType = $userLogic->getUserType($user['user_login'], $user['user_id'], $user['user_is_super']);
 		//if ($userType == 0) die(json_encode(sp_api_fail(ERR_OP_ERR, "非管理员不能登录", JSON_UNESCAPED_UNICODE))) ;

		$user['user_type'] = 1;
		sp_set_user($user) ;
		$_SESSION['grant']="tokenlogin";
		redirect('/Admin/index/index');
	}
	
	
	public function toUrl($to){

		//如果 to 是应用的话
		if (strpos($to, '/') == false){
			return U("$to/public/load");
		}else{
			return $to ;
		}

	}
	
	

	/**
	 * 显示验证码
	 */
	public function verify(){
		ob_clean();
		$Verify = new \Think\Verify();
		$Verify->fontSize = 30;
		$Verify->length   = 4;
		$Verify->useNoise = false;
		$Verify->entry();
	
	}
	
	
	/**
	 * 验证
	 * @param unknown $code
	 * @param string $id
	 * @return boolean
	 */
	public function check_verify($code, $id = ''){
		$verify = new \Think\Verify();
		return $verify->check($code, $id);
	}


}